/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.fluid;

import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.mixin.accessors.common.accessor.BucketItemAccessor;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import io.github.fabricators_of_create.porting_lib.util.FluidTextUtil;
import io.github.fabricators_of_create.porting_lib.util.FluidUnit;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3965;
import net.minecraft.class_5328;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.config.Config;
import slimeknights.mantle.fluid.transfer.FluidContainerTransferManager;
import slimeknights.mantle.fluid.transfer.IFluidContainerTransfer;

public class FluidTransferHelper {
    private static final String KEY_FILLED = Mantle.makeDescriptionId("block", "tank.filled");
    private static final String KEY_FILLED_DROPLET = Mantle.makeDescriptionId("block", "tank.filled.droplets");
    private static final String KEY_DRAINED = Mantle.makeDescriptionId("block", "tank.drained");
    private static final String KEY_DRAINED_DROPLET = Mantle.makeDescriptionId("block", "tank.drained.droplets");

    public static String getKeyFilled() {
        return Config.FLUID_UNIT.get() == FluidUnit.MILLIBUCKETS ? KEY_FILLED : KEY_FILLED_DROPLET;
    }

    public static String getKeyDrained() {
        return Config.FLUID_UNIT.get() == FluidUnit.MILLIBUCKETS ? KEY_DRAINED : KEY_DRAINED_DROPLET;
    }

    public static FluidStack tryTransfer(Storage<FluidVariant> input, Storage<FluidVariant> output, long maxFill, boolean force) {
        for (StorageView view : input) {
            long maxExtracted;
            if (view.isResourceBlank()) continue;
            FluidVariant resource = (FluidVariant)view.getResource();
            try (Transaction extractionTestTransaction = Transaction.openOuter();){
                maxExtracted = view.extract((Object)resource, maxFill, (TransactionContext)extractionTestTransaction);
                extractionTestTransaction.abort();
            }
            try (Transaction transferTransaction = Transaction.openOuter();){
                long accepted = output.insert((Object)resource, maxExtracted, (TransactionContext)transferTransaction);
                long drained = view.extract((Object)resource, accepted, (TransactionContext)transferTransaction);
                if (accepted == 0L || drained == 0L || drained != accepted && !force) {
                    transferTransaction.abort();
                    Mantle.logger.debug("Lost {} fluid during transfer, cancelled transfer", (Object)(drained - accepted));
                    FluidStack fluidStack = FluidStack.EMPTY;
                    return fluidStack;
                }
                transferTransaction.commit();
                FluidStack fluidStack = new FluidStack(resource, drained);
                return fluidStack;
            }
        }
        return FluidStack.EMPTY;
    }

    public static boolean interactWithBucket(class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_2350 hit, class_2350 offset) {
        class_1755 bucket;
        class_3611 fluid;
        class_1799 held = player.method_5998(hand);
        class_1792 class_17922 = held.method_7909();
        if (class_17922 instanceof class_1755 && (fluid = ((BucketItemAccessor)(bucket = (class_1755)class_17922)).port_lib$getContent()) != class_3612.field_15906) {
            FluidStack fluidStack;
            Storage handler;
            if (!world.field_9236 && (handler = (Storage)FluidStorage.SIDED.find(world, pos, (Object)hit)) != null && StorageUtil.simulateInsert((Storage)handler, (Object)(fluidStack = new FluidStack(((BucketItemAccessor)bucket).port_lib$getContent(), 81000L)).getType(), (long)fluidStack.getAmount(), null) == 81000L) {
                try (Transaction t = TransferUtil.getTransaction();){
                    handler.insert((Object)fluidStack.getType(), fluidStack.getAmount(), (TransactionContext)t);
                    t.commit();
                }
                bucket.method_7728(player, world, held, pos.method_10093(offset));
                world.method_8396(null, pos, FluidVariantAttributes.getEmptySound((FluidVariant)FluidVariant.of((class_3611)fluid)), class_3419.field_15245, 1.0f, 1.0f);
                player.method_7353((class_2561)class_2561.method_43469((String)FluidTransferHelper.getKeyFilled(), (Object[])new Object[]{FluidTextUtil.getUnicodeMillibuckets((long)81000L, (FluidUnit)((FluidUnit)Config.FLUID_UNIT.get()), (boolean)true), fluidStack.getDisplayName()}), true);
                if (!player.method_7337()) {
                    player.method_6122(hand, held.getRecipeRemainder());
                }
            }
            return true;
        }
        return false;
    }

    private static void playEmptySound(class_1937 world, class_2338 pos, class_1657 player, FluidStack transferred) {
        world.method_8396(null, pos, FluidVariantAttributes.getHandlerOrDefault((class_3611)transferred.getFluid()).getEmptySound(transferred.getType()).orElse(class_3417.field_14834), class_3419.field_15245, 1.0f, 1.0f);
        player.method_7353((class_2561)class_2561.method_43469((String)FluidTransferHelper.getKeyFilled(), (Object[])new Object[]{FluidTextUtil.getUnicodeMillibuckets((long)transferred.getAmount(), (FluidUnit)((FluidUnit)Config.FLUID_UNIT.get()), (boolean)true), transferred.getDisplayName()}), true);
    }

    private static void playFillSound(class_1937 world, class_2338 pos, class_1657 player, FluidStack transferred) {
        world.method_8396(null, pos, FluidVariantAttributes.getHandlerOrDefault((class_3611)transferred.getFluid()).getFillSound(transferred.getType()).or(() -> transferred.getFluid().method_32359()).orElse(class_3417.field_15126), class_3419.field_15245, 1.0f, 1.0f);
        player.method_7353((class_2561)class_2561.method_43469((String)FluidTransferHelper.getKeyDrained(), (Object[])new Object[]{FluidTextUtil.getUnicodeMillibuckets((long)transferred.getAmount(), (FluidUnit)((FluidUnit)Config.FLUID_UNIT.get()), (boolean)true), transferred.getDisplayName()}), true);
    }

    public static boolean interactWithFluidItem(class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        Storage teHandler;
        class_1799 stack = player.method_5998(hand);
        class_2350 face = hit.method_17780();
        if (!stack.method_7960() && (teHandler = (Storage)FluidStorage.SIDED.find(world, pos, (Object)face)) != null) {
            class_1799 copy = ItemHandlerHelper.copyStackWithSize((class_1799)stack, (int)1);
            if (FluidContainerTransferManager.INSTANCE.mayHaveTransfer(stack)) {
                IFluidContainerTransfer.TransferResult result;
                FluidStack currentFluid;
                IFluidContainerTransfer transfer;
                if (!world.field_9236 && (transfer = FluidContainerTransferManager.INSTANCE.getTransfer(stack, currentFluid = TransferUtil.simulateExtractAnyFluid((Storage)teHandler, (long)Long.MAX_VALUE))) != null && (result = transfer.transfer(stack, currentFluid, (Storage<FluidVariant>)teHandler)) != null) {
                    if (result.didFill()) {
                        FluidTransferHelper.playFillSound(world, pos, player, result.fluid());
                    } else {
                        FluidTransferHelper.playEmptySound(world, pos, player, result.fluid());
                    }
                    player.method_6122(hand, class_5328.method_30012((class_1799)stack, (class_1657)player, (class_1799)result.stack()));
                }
                return true;
            }
            if (FluidStorage.ITEM.find(stack, (Object)ContainerItemContext.withConstant((class_1799)stack)) != null) {
                if (!world.field_9236) {
                    Storage itemHandler = (Storage)ContainerItemContext.forPlayerInteraction((class_1657)player, (class_1268)hand).find(FluidStorage.ITEM);
                    FluidStack transferred = FluidTransferHelper.tryTransfer((Storage<FluidVariant>)itemHandler, (Storage<FluidVariant>)teHandler, Long.MAX_VALUE, player.method_7337());
                    if (!transferred.isEmpty()) {
                        FluidTransferHelper.playEmptySound(world, pos, player, transferred);
                    } else {
                        transferred = FluidTransferHelper.tryTransfer((Storage<FluidVariant>)teHandler, (Storage<FluidVariant>)itemHandler, Integer.MAX_VALUE, player.method_7337());
                        if (!transferred.isEmpty()) {
                            FluidTransferHelper.playFillSound(world, pos, player, transferred);
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }

    public static boolean interactWithTank(class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        return FluidTransferHelper.interactWithFluidItem(world, pos, player, hand, hit) || FluidTransferHelper.interactWithBucket(world, pos, player, hand, hit.method_17780(), hit.method_17780());
    }

    private FluidTransferHelper() {
    }
}

